﻿/*
 
C#-Programm: Moneysplitter (c)2014 by www.gossmann.at
C#-Übung: T1A6 – Geldbetrag
V0.9 - last mod: 151114

Aufgabenstellung (Zweck: Arrays lernen):
----------------------------------------

Stückeln Sie den über Konsole eingegebenen Geldbetrag in möglichst wenig Euro Scheine und
Münzen. Unterstützen Sie auch Fliesskommabeträge und alle Euro Scheine und Münzen inkl der Cent
Münzen.

Fleißaufgabe:

Abfangmaßnahme bei ungütligen Werten, Neustart-Frage, Einzahl / Mehrzahl bei Ausgabe der Geldschein(e) und Münze(n) berücksichtigt

weitere Optimierungsmöglichkeiten:
----------------------------------

10-EUR u. 5-EUR-Münze berücksichtigen (nach Wunsch)
Anzahl der vorrätigen Scheine- / Münzen in einem eigenen Feld vorrätig halten und bei Erreichen von 0 neu zu Stückeln beginnen
(wäre dann echte Bankomatauszahlung, wenn von irgendwelchen Scheinen keine mehr vorrätig wären, dann muss eben auf andere, d.h. nächstkleinere ausgewichen werden...)

*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Bankomat
{
    class Moneysplitter
    {
        // d. Methode fragt die fast überall und immer wieder gebrauchten J/N-Tasten ab und liefert entsprechend true für j und false für n
        // Groß- / Kleinschreibungsmodus ist dabei egal

        public static bool yesno_Q()
        {

        char CH_wish_JN; // dient der J/N-Abfrage

        LB_restart_select:
        CH_wish_JN = Convert.ToChar (Console.ReadKey().KeyChar); // Taste holen lassen
        CH_wish_JN = char.ToLower                  (CH_wish_JN); // nur Kleinschreibung testen, damit nicht auch Großbuchstaben getestet werden müssen im Switch

        switch (CH_wish_JN)
               {
               case 'j': return true           ; // Wunsch ja übergeben - was Aufrufer mit der Info macht = sein Kaffee
               case 'n': return false          ; // Wunsch nein übergeben - was Aufrufer mit der Info macht = auch sein Kaffee
               default : goto LB_restart_select; // ungültige Taste gedrückt (kein j/n) - User nicht aus der Methode lassen, solange er nicht das gewünschte drückt
               }
        } // END-method: yesno_Q

        static void Main(string[] args)

        {

        // Deklarations- u. Initialisierungsteil:
        // --------------------------------------

        bool      bl_coinswitch                                                                                ; // dient zur Umschaltung auf Münzausgabe

        decimal[] ARdec_cash    = { 500, 200, 100, 50, 20, 10, 5, 2, 1, 0.5m, 0.2m, 0.1m, 0.05m, 0.02m, 0.01m }; // Feld mit den Geld / Münzstückelungswerten initialisieren (decimal wegen höchster Genauigkeit)
        decimal   dec_bcash                                                                                    ; // der Puffer für den eigentlichen Wert, der gestückelt werden soll
        decimal   dec_cash                                                                                     ; // der eigentliche Wert, der gestückelt werden soll -> holen lassen vom User
        decimal   dec_amount                                                                                   ; // die Anzahl der Scheine- / Münzen, in die gestückelt wird

        LB_restart_prg:
        
        bl_coinswitch           =                                                                         false; // standard. davon ausgehen, dass auch Geldscheine gestückelt werden müssen und nicht nur Münzen

        // ab Unterschreitung von 5 Euro, werden nur noch Münzen ausgezahlt, allerdings wird vorerst davon ausgehen, dass Geldscheine gestückelt werden...
        // für Einzahl und Mehrzahlausgabe einen String dafür initialisieren
        string s_cashtext_sing  =                                                                  "Geldschein";  
	    string s_cashtext_plur  =                                                                 "Geldscheine";


        Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

        // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

        Console.WriteLine ("Moneysplitter V0.9 - (c) by www.gossmann.at, nov-2014:"           );
        Console.WriteLine                                                                  (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("Moneysplitter berechnet anhand eines eingegebenen Geldbetrages,"  );
        Console.WriteLine ("in welche und wie wenige Geldscheinen sowie Münzen der Betrag bei");
        Console.WriteLine ("Auszahlung aufgeteilt werden kann."                               );
        Console.WriteLine                                                                  (""); // Übersichtsleerzeile einstreuen...

        // Eingabeteil: zu stückelnden Geldbetrag holen
        // --------------------------------------------

        // Geldbetrag im try-Block holen lassen, da User auch Schrott eingeben könnte...
        try
          {
          Console.WriteLine("Bitte geben Sie den gewünschten Geldbetrag ein:");
          Console.WriteLine                                               (""); // Übersichtsleerzeile einstreuen...
          dec_cash = Convert.ToDecimal                    (Console.ReadLine()); // gebraucht wird dieses Mal der Wert mit höchster Genauigkeit im Angebot von C# und das ist nun Mal der "decimal"
          }

        // ungültigen Wert bei Kovertierung entdeckt (alphanumerisches Zeugs) -> durch Exception-Handler abfangen
        catch
            {
            Console.WriteLine                                                                                                        (""); // Übersichtsleerzeile einstreuen...
            Console.WriteLine("Leider haben Sie einen ungültigen Wert eingegeben - bitte auf Kommapunkt, bzw. Leerzeichen, etc. achten!");
            goto LB_restart_select                                                                                                       ; // mittels zwar verpöntem, aber leider an der Stelle notwendigem goto Neustartabfrage durchführen
            }

          // zwar gültiger Wert eingegeben, das heißt aber noch lange nicht brauchbar (negativ / Null-Ausschluss):
          if (dec_cash<=0)                                                                                                 // liegt positiver Betrag vor - nur der kann nämlich ausgefolgt und daher gestückelt werden?
             {
             Console.WriteLine                                                                                                        (""); // Übersichtsleerzeile einstreuen...
             Console.WriteLine("Wenn Sie kein Geld haben, kann Ihnen auch leider keines gestückelt ausgefolgt werden..."); // nein -> Meldung dafür ausgeben
             goto LB_restart_select                                                                                      ; // Neustartsabfrage durchführen - vielleicht hat der arme Schlucker bis dahin ja schon von wo Geld aufs Konto überwiesen bekommen
             }

          // ab hier ist Wert gültig und brauchbar -> Verarbeitungs- u. Ausgabeteil einleiten:
          // ---------------------------------------------------------------------------------
          
          dec_bcash = dec_cash; // Ursprungsbetrag sichern (für Ausgabe, wenn auf Münzen geschaltet wird

          if (dec_cash>=5)                                                                                          // Erstcheck: sind Scheine für das Stückeln überhaupt erforderlich (unter 5 Euro können nur Münzen ausgezahlt werden).
             {
             Console.WriteLine                                                                                (""); // Übersichtsleerzeile einstreuen...
             Console.WriteLine      ("Vom Geldbetrag in Höhe von: "+dec_cash+" kriegen Sie folgende Geldscheine:"); // ja -> Meldung dafür ausgeben
             Console.WriteLine                                                                                (""); // Übersichtsleerzeile einstreuen...
             }
          else // an dieser Stelle leicht modifizierte Ausgabe, da NUR MÜNZEN gestückelt ausgegeben werden, ansonsten erfolgt unten in der Schleife die Umschaltung
             {
             s_cashtext_sing   =                                                                           "Münze"; // ja -> Strings für Münzen anpassen (Einzahl und Mehrzahl)
	         s_cashtext_plur   =                                                                          "Münzen";
         	 bl_coinswitch     =                                                                              true; // vermerken, dass schon auf Münzen geschaltet wurde
             Console.WriteLine                                                                                (""); // Übersichtsleerzeile einstreuen...
             Console.WriteLine ("Vom Geldbetrag in Höhe von: " + dec_bcash + " ergeben sich nur folgende Münzen:"); // ab hier Münzmeldung machen, da nur mehr Münzen gestückelt werden
             Console.WriteLine                                                                                (""); // Übersichtsleerzeile einstreuen...
             }

          // alle Schein- / Münztypen abgrasen lassen - falls schon vorzeitig alles aufgestückelt wurde, wird "gebreaked"
          foreach (decimal dc_moneytype in ARdec_cash)
                  {
                  dec_amount =                                                          Math.Truncate(dec_cash / dc_moneytype); // nur Vorkommaanteil ist für Stückelung interessant,
                  dec_cash   =                                                                         dec_cash % dc_moneytype; // dafür interessiert der neue Restbetrag samt Nachkommaanteil

                  if (dec_amount == 1)                                                                                          // genau 1 Einheit d. jeweiligen Schein- / Münztyps zum Stückeln?
                     {

                     // an dieser Stelle müsste die jeweilige Methode vom Bankomat / Fahrkartenautomat aufgerufen werden, das (Wechsel)geld herauszurücken...
                     // natürlich müsste zuerst ein kompletter Testlauf erfolgen, ob denn auch alle Scheine vorhanden sind - könnte ja sein, dass zu wenig Scheine auf Vorrat liegen
                     // hier bleibt´s bei der Textausgabe...

                     Console.WriteLine("Sie kriegen: " + dec_amount + " x " + dc_moneytype + "er-" + s_cashtext_sing          ); // ja -> Einzahlausgabe des jeweiligen Typs (Schein / Münze)
                     }
                  if (dec_amount > 1)                                                                                            // mehr als 1 Einheit d. jeweiligen Schein- / Münztyps zum Stückeln?
                     {

                     // an dieser Stelle müsste die jeweilige Methode vom Bankomat / Fahrkartenautomat aufgerufen werden, das (Wechsel)geld herauszurücken...
                     // natürlich müsste zuerst ein kompletter Testlauf erfolgen, ob denn auch alle Scheine vorhanden sind - könnte ja sein, dass zu wenig Scheine auf Vorrat liegen
                     // hier bleibt´s bei der Textausgabe...

                     Console.WriteLine("Sie kriegen: " + dec_amount + " x " + dc_moneytype + "er-" + s_cashtext_plur          ); // ja -> Mehrzahlausgabe des jeweiligen Typs (Schein / Münze)
                     }

                  if (dec_cash == 0)                                                                                             // schon alles gestückelt?
                     {
                     break                                                                                                     ; // ja -> vorzeit Feierabend machen
                     }
                  // es gibt eigentlich auch 10- u. 5-EUR-Münzen... diese sind hier aber nicht berücksictigt....

                  if ( (bl_coinswitch==false) && (dec_cash<5) )                                                                  // unter 5 Euro muss daher mangels EUR-Scheintypen dafür auf Münzen umgeschaltet werden - darf nur 1x geschehen, da sonst ständig Meldung ausgegeben werden würde
                     {
         	         s_cashtext_sing =                                                                                  "Münze"; // ja -> Strings für Münzen anpassen (Einzahl und Mehrzahl)
	                 s_cashtext_plur =                                                                                 "Münzen";
         		     bl_coinswitch   =                                                                                     true; // vermerken, dass schon auf Münzen geschaltet wurde
                     Console.WriteLine                                                                                     (""); // Übersichtsleerzeile einstreuen...
                     Console.WriteLine("Vom Geldbetrag in Höhe von: " + dec_bcash + " ergeben sich noch die folgenden Münzen:"); // ab hier Münzmeldung machen, da nur mehr Münzen gestückelt werden
                     Console.WriteLine                                                                                     (""); // Übersichtsleerzeile einstreuen...
                     }

                  }

          LB_restart_select:
          Console.WriteLine                                    (""); // Übersichtsleerzeile einstreuen...
          Console.WriteLine("noch eine Stückelung berechnen (j/n)");
          if (yesno_Q()) goto LB_restart_prg                       ; // wurde "j" gedrückt, dann Programm neu starten
        
          }
    }
}