﻿/*
 
C#-Programm: ZinsesZinsoCalco (c)2014 by www.gossmann.at
C#-Übung: T1M1 – Guthaben berechnen
V0.9 - last mod: 091114

Aufgabenstellung (Zweck: Methoden lernen):
------------------------------------------
                                      ???gemeint wohl double guthaben???
Implementieren Sie die Methode double ZinsenBerechnen(int guthaben, int laufzeit, double
zinssatz). Diese Methode berechnet den Wert des guthaben nach Ablauf von laufzeit Jahren unter
Anwendung von zinssatz und gibt das Resultat zurück.
  
Fleißaufgabe:

Abfangmaßnahme bei ungütligen Werten, Neustart-Frage (diesmal auch gleich in eine Methode verfrachtet...), normale Zinsen in der Methode

*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZinsesZinsoCalco
{
    class Program
    {
        // d. Methode fragt die fast überall und immer wieder gebrauchten J/N-Tasten ab und liefert entsprechend true für j und false für n
        // Groß- / Kleinschreibungsmodus ist dabei egal

        public static bool yesno_Q()
        {

        char CH_wish_JN; // dient der J/N-Abfrage

        LB_restart_select:
        CH_wish_JN = Convert.ToChar (Console.ReadKey().KeyChar); // Taste holen lassen
        CH_wish_JN = char.ToLower                  (CH_wish_JN); // nur Kleinschreibung testen, damit nicht auch Großbuchstaben getestet werden müssen im Switch

        switch (CH_wish_JN)
               {
               case 'j': return true           ; // Wunsch ja übergeben - was Aufrufer mit der Info macht = sein Kaffee
               case 'n': return false          ; // Wunsch nein übergeben - was Aufrufer mit der Info macht = auch sein Kaffee
               default : goto LB_restart_select; // ungültige Taste gedrückt (kein j/n) - User nicht aus der Methode lassen, solange er nicht das gewünschte drückt
               }
        } // END-method: yesno_Q

        // d. Methode berechnet anhand der boolschen Variable ZZins (true) Zinseszinsen oder eben nicht (false) und rundet die gleich auf 2 Nachkommastellen
        public static double Zinsen_berechnen (double dbl_money, int lg_years, double dbl_percent, bool ZZins)
        {
        /*
        Formeln:
        --------
        
        K(0) = Startkapital
        p=Zinssatz
        n=Laufzeit in Jahren                

        a) verwendete Zinseszinsformel:
        -------------------------------
        
        K(n) = K(0) * (1+p) ^ n

        b) verwendete Normalzinseszinsformel, wenn User jährlich die Zinsen kassiert, anstatt kapitalisieren lässt
        ----------------------------------------------------------------------------------------------------------
        
        K(n) = K(0) + (p / 100) * K(0) * n
         
        */
        if (ZZins)                                                                               // Berechnung mit Zinseszinsen?
           return  Math.Round( (dbl_money * Math.Pow( (1 + dbl_percent / 100 ), lg_years )), 2); // ja -> berechnen und an Aufrufer übergeben 
        else
           return  Math.Round( dbl_money + (dbl_percent / 100) * dbl_money * lg_years      , 2); // nein -> nur normale Zinsen berechnen und an Aufrufer übergeben
        } // END-method: Zinsen_berechnen
        
        // BEGIN: Hauptprogramm
        static void Main(string[] args)
        {

        // aktueller Scope hat folgende gleiche Namen wie entsprechende Methode, da die Variablen in der Methode eh nur lokal gelten (=aus Übersichtsgründen)

        double  dbl_money  ; // Startkapital
        double  dbl_percent; // Zinssatz
        int     lg_years   ; // Laufzeit

        LB_restart_prg:

        Console.Clear(); // Platz da am Konsolen-Schirm -> Wisch- und Weg machen...

        // dem User kurze Infos zum Programm und einen Erklärungsteil präsentieren:

        Console.WriteLine ("ZinsesZinsoCalco V0.9a - (c) by www.gossmann.at, nov-2014:"                                                 );
        Console.WriteLine                                                                                                            (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("ZinsesZinsoCalco berechnet Ihr Endkapital inkl. Zinseszinsen nach einer entsprechenden Laufzeit (in Jahren)");
        Console.WriteLine                                                                                                            (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("Außerdem gibt Ihnen das Program auch normale (nicht kapitalisierte) Zinsen aus"                             );

        // Eingabeteil: Kapital, Zinssatz und Laufzeit holen
        // natürlich ließe sich auch jede einzelne Operation in einem eigenen try-catch-Block einfassen, wenn User Schrott eingibt, wäre hier aber zu unübersichtlich...
        // daher alle 3 zusammen - heißt aber auch 1x was falsch eingeben wird mit Neustart des gesamten Programms bestraft... ;)
 
        try
          {

          LB_reget_money:          

          Console.WriteLine ("Bitte Startkapital eingeben:"    ); 
          Console.WriteLine                                 (""); // Übersichtsleerzeile einstreuen...
          dbl_money   = Convert.ToDouble ( Console.ReadLine() ) ; // Startkapital holen
        
          // negative, bzw. 0-Beträge nützen dem User nichts (nur der Bank in Form hoher Soll-Zinsen - dafür stimmt aber die Zinseszins-Formel dann nicht)
          if ( dbl_money<=0 )
             {
             Console.WriteLine                                                                  (""); // Übersichtsleerzeile einstreuen...
             Console.WriteLine("Negative, bzw. 0-Beträge können hier leider nicht verzinst werden!");
             Console.WriteLine                                                                  (""); // Übersichtsleerzeile einstreuen...
             goto LB_reget_money                                                                    ;         
             }

          LB_reget_percent:
          
          Console.WriteLine                                 (""); // Übersichtsleerzeile einstreuen...
          Console.WriteLine ("Bitte Zinssatz eingeben:"        ); 
          Console.WriteLine                                 (""); // Übersichtsleerzeile einstreuen...
          dbl_percent = Convert.ToDouble ( Console.ReadLine() ) ; // Zinssatz holen
          
          // negative, bzw. 0-Verzinsung braucht sich der User keine aufschwatzen lassen... -> neue Eingabe verlangen
          if ( dbl_percent<=0 )
             {
             Console.WriteLine                                                                  (""); // Übersichtsleerzeile einstreuen...             
             Console.WriteLine("Wechseln Sie lieber zu einer Bank, die Ihnen positive Zinsen gibt!");
             Console.WriteLine                                                                  (""); // Übersichtsleerzeile einstreuen...             
             goto LB_reget_percent                                                                  ;
             }

          LB_reget_years:            

          Console.WriteLine                                 (""); // Übersichtsleerzeile einstreuen...
          Console.WriteLine ("Bitte Laufzeit eingeben (Jahre):"); 
          Console.WriteLine                                 (""); // Übersichtsleerzeile einstreuen...
          lg_years    = Convert.ToInt32   ( Console.ReadLine() ); // Laufzeit holen

          // negative Jahre gibt es nicht -> neue Eingabe verlangen
          if ( lg_years<0 )
             {
             Console.WriteLine                                                                                                                                             (""); // Übersichtsleerzeile einstreuen...
             Console.WriteLine("Echt? Sie haben eine Zeitmaschine? Notieren Sie sich die Lottozahlen, reisen zurück und kassieren Sie den Jackpot - so kriegen Sie auch Geld!");
             Console.WriteLine                                                                                                                                             (""); // Übersichtsleerzeile einstreuen...             
             goto LB_reget_years                                                                                                                                               ;
             }

          // 0 Jahre anlegen ist hier auch unzulässig...
          if ( lg_years==0 )
             {
             Console.WriteLine                                                                                                                                             (""); // Übersichtsleerzeile einstreuen...
             Console.WriteLine                                                                                                           ("Sie müssen mind. ein Jahr eingeben");
             Console.WriteLine                                                                                                                                             (""); // Übersichtsleerzeile einstreuen...             
             goto LB_reget_years                                                                                                                                               ;
             }
          }

        // ungültigen Wert bei Kovertierung entdeckt (alphanumerisches Zeugs) -> durch Exception-Handler abfangen

        catch
            {
            Console.WriteLine                                                                                                         (""); // Übersichtsleerzeile einstreuen...
            Console.WriteLine ("Leider haben Sie einen ungültigen Wert eingegeben - bitte auf Kommapunkt, bzw. Leerzeichen, etc. achten!");
            goto LB_restart_select                                                                                                        ; // mittels zwar verpöntem, aber leider an der Stelle notwendigem goto Neustartabfrage durchführen
            }

        // Verarbeitungs- u. Ausgabeteil:
        // ------------------------------

        // Berechnung mit der Methode "Zinsen_berechnen" durchführen lassen (und nicht direkt im Main-Code), wobei das Ergebnis gleich ausgegeben wird
        // (spart temporäre Zwischenvariable an der Stelle und da sonst nirgends gebraucht, kann das hier ruhig so gemacht werden)
        
        Console.WriteLine                                                                                             (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ( "Sie kriegen für Ihr Kapital in Höhe von " + dbl_money + " Euro nach "
                          + lg_years + " Jahren Laufzeit beim Zinssatz von "
                          + dbl_percent +"% "
                          + Zinsen_berechnen (dbl_money, lg_years, dbl_percent, true) +" Euro inkl. Zinseszinsen heraus.");
        Console.WriteLine                                                                                             (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("Wenn Sie dagegen in Saus und Braus leben und die Zinsen jährlich kassieren, kriegen Sie nur: "
                          + Zinsen_berechnen (dbl_money, lg_years, dbl_percent, false) +" Euro heraus."                  );

        // Programmneustartsabfrage (es gibt Dinge, die gehen eben nur mit goto...)

        LB_restart_select:

        Console.WriteLine                           (""); // Übersichtsleerzeile einstreuen...
        Console.WriteLine ("noch eine Berechnung (j/n)");

       if (yesno_Q()) goto LB_restart_prg; // wurde "j" gedrückt, dann Programm neu starten
//     else return                         // Feierabend für Main -> Exit-Code 0 geben für normale Terminierung - gesamtes Else wurde gespart, da sowieso nichts mehr da an Code - bei Erweiterung muss es wieder rein!
       
       }
    }
}
